<?php

namespace App\Http\Controllers;

use App\Models\Keranjang;
use App\Models\Ongkirmember;
use App\Models\Pembayaran;
use App\Models\Transaksi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class KasirController extends Controller
{
    public function index()
    {
        $jmltotal = Transaksi::selectRaw('SUM(total) as jml')
            ->where('user_id', Auth::user()->id)
            ->first();

        $ttlitem = Keranjang::join('transaksis', 'keranjangs.transaksi_id', '=', 'transaksis.id')
            ->selectRaw('SUM(keranjangs.jumlah) as jml')
            ->where('user_id', Auth::user()->id)
            ->first();
        $tottran = Transaksi::where('user_id', Auth::user()->id)->count();
        $member = Ongkirmember::where('sts_alamat', 'N')->get();
        $data = [
            'title' => 'Ramizah Store | Home',
            'page' => 'Home',
            'menuActive' => 'home',
            'menuOpen' => 'home',
            'tottran' => number_format($tottran, 0, ',', '.'),
            'ttlitem' => number_format($ttlitem->jml, 0, ',', '.'),
            'jmltotal' => number_format($jmltotal->jml, 0, ',', '.'),
        ];
        return view('kasir.home', compact('data', 'member'))->with('no', 1);
    }

    public function cek_orderan()
    {
        if (konfirmasi() > 0) {
            return response()->json(konfirmasi());
        } else {
            return response()->json(0);
        }
    }

    public function data_orderan()
    {
        $order  = Pembayaran::latest()->get();
        return view('kasir.data_order', compact('order'));
    }

    public function cek_member()
    {
        $m = Ongkirmember::where('sts_alamat', 'N')->count();
        return response()->json($m);
    }

    public function data_member()
    {
        $member = Ongkirmember::where('sts_alamat', 'N')->get();
        foreach ($member as $m) {
            $data = ' <a href="" class="dropdown-item">
                                <i class="fas fa-users mr-2"></i>' . $m->member->nm_member . '
                                <span class="float-right text-muted text-sm">' . tgl_inf($m->created_at) . '</span>
                            </a>
                            <div class="dropdown-divider"></div>';
        }

        return response()->json($data);
    }

    public function laporan()
    {
        $member = Ongkirmember::where('sts_alamat', 'N')->get();
        $data = [
            'title' => 'Ramizah Store | Laporan Invoice',
            'page' => 'Laporan Invoice',
            'menuActive' => 'laporan',
            'menuOpen' => 'laporan',
        ];
        return view('kasir.laporan.invoice', compact('data', 'member'))->with('no', 1);
    }

    public function cek_invoice(Request $request)
    {
        $tgl = $request->tgl;
        $jam1 = $request->jam1;
        $jam2 = $request->jam2;

        $tgl1 = date('Y-m-d H:i:s', strtotime($tgl .  $jam1));
        $tgl2 = date('Y-m-d H:i:s', strtotime($tgl .  $jam2));

        $totaltransaksi = Transaksi::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s')"), '>=', $tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s')"), '<=', $tgl2)
            ->where('user_id', Auth::user()->id)
            ->count();

        $jmltotal = Transaksi::selectRaw('SUM(total) as jml')->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s')"), '>=', $tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s')"), '<=', $tgl2)
            ->where('user_id', Auth::user()->id)
            ->first();

        $viatf = Transaksi::selectRaw('SUM(total) as jml')->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s')"), '>=', $tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s')"), '<=', $tgl2)->where('via_bayar', 'T')
            ->where('user_id', Auth::user()->id)
            ->first();

        $jambuka = date('d M Y H:i', strtotime($tgl .  $jam1));
        $jamtutup = date('d M Y H:i', strtotime($tgl .  $jam2));

        $data = [
            'jambuka' =>   $jambuka,
            'jamtutup' =>   $jamtutup,
            'totaltransaksi' =>   number_format($totaltransaksi, 0, ',', '.'),
            'jmltotal' =>   number_format($jmltotal->jml, 0, ',', '.'),
            'viatf' =>   number_format($viatf->jml, 0, ',', '.'),
            'ungkasir' =>   number_format($jmltotal->jml - $viatf->jml, 0, ',', '.'),
        ];
        return view('kasir.laporan.v_laporan', compact('data'));
    }
}
